/**
 * 
 */
/**
 * @author Janet Lopez
 *
 */
package gov.va.genisis2Test.service.impl;

import static org.junit.Assert.assertNull;

import java.util.Date;
import java.util.List;

import org.junit.Assert;
import org.junit.Test;
import org.slf4j.LoggerFactory;

import gov.va.genisis2.model.CommentHistory;
import gov.va.genisis2.model.Request;
import gov.va.genisis2.model.RequestHistory;
import gov.va.genisis2.model.RequestType;
import gov.va.genisis2.model.Source;
import gov.va.genisis2.model.StudyApproval;
import gov.va.genisis2.model.WorkflowStatus;
import gov.va.genisis2.service.impl.RequestService;
import gov.va.genisis2Test.abstractClass.AbstractMockMvcTests;
import gov.va.genisis2Test.util.Helper;


/**
 * The Class RequestServiceTest.
 *
 * @author1 Janet Lopez
 * @author Getaneh Kassahun
 * 
 *          The Class RequestServiceTest.
 * 
 *          Description: In this RequestServiceTest Class which extends the
 *          abstract class, AbstractMockMvcTests, junit tests are defined.
 */

public class RequestServiceTest extends AbstractMockMvcTests {
	
	/** The logger. */
	private final org.slf4j.Logger logger = LoggerFactory.getLogger(RequestServiceTest.class);

	/**
	 * Test request service.
	 */
	@SuppressWarnings("unused")
	@Test
	public void testRequestService() {

		logger.info("**********Junit Test Request Service**********");

		RequestService requestService = new RequestService();
		assertNull(requestService.getRequestDao());
		requestService.setRequestDao(getMockRequestDao());

		Request request = Helper.getExistingRequest();

		getMockHibernateTemplate().save(request);

		int requestId = requestService.createRequest(request);
		Request requesta = requestService.getRequestsById(requestId);

		Source source = Helper.getNewSource();
		getMockHibernateTemplate().save(source);

		Source source1 = requestService.getSource(1);
		// Assert.assertNotNull(source1.getId());
		List<Source> sources = requestService.getDataSources();
		Assert.assertNotNull(sources);

		RequestType requestType = Helper.getNewRequestType();
		getMockHibernateTemplate().save(requestType);

		RequestType requestType1 = requestService.getRequestType(1);
		// Assert.assertNotNull(requestType1.getId());
		List<RequestType> requestTypes = requestService.getRequestTypes();
		Assert.assertNotNull(requestTypes);

		int requestIdb = requestService.submitOrModify(request);
		Assert.assertEquals(requestId, requestIdb);

		RequestHistory requestHistory = new RequestHistory();
		List<RequestHistory> requestListH = requestService.getRequestHistoryById(requestId);
		int hRid = requestService.submitOrModify(requestHistory);
		Assert.assertNotNull(hRid);

		List<Request> requestListA = requestService.getAllRequests();
		Assert.assertNotNull(requestListA);

		List<Request> requestListS = requestService.getAllRequestsByStaus("status");
		Assert.assertNotNull(requestListS);
		
		List<RequestHistory> requestListRequestHistoryByRequestIdAndStatus = requestService.getRequestHistoryByRequestIdAndStatus(request.getId(), "status");
		Assert.assertNotNull(requestListRequestHistoryByRequestIdAndStatus);
		
		List<Request> requestListBDM = requestService.getRequestsByDataManagers("userId");
		Assert.assertNotNull(requestListBDM);
		List<Request> requestListDM = requestService.getRequestsDataManagers("userId");
		Assert.assertNotNull(requestListDM);
		
		List<Request> requestListDSM = requestService.getRequestsDataSourceManagers("userId");
		Assert.assertNotNull(requestListDSM);
		
		
		List<Request> requestListU = requestService.getRequestsByUID("userId");
		Assert.assertNotNull(requestListU);
		int studyApprovalId = 1;
		StudyApproval studyApproval = Helper.getStudyApproval();
		getMockHibernateTemplate().save(studyApproval);

		List<Request> requestListSA = requestService.getAllRequestsByStudyApproval(studyApprovalId);
		Assert.assertNotNull(requestListSA);

		int commentHistoryId = 1;
		CommentHistory commentHistory = new CommentHistory(1, new Request(), new WorkflowStatus(), "commentsTestOne",
				new Date(), "datamanger1", "taskId");
		getMockHibernateTemplate().save(commentHistory);

		List<Request> requestListC = requestService.getAllRequestsByCommentHistory(commentHistoryId);
		Assert.assertNotNull(requestListC);

		logger.info("**********End Junit Test Request Service**********");
	}
}